
--locale variables
local total_meteors = 6
local meteors = {}
local meteors_x_pos = {}
local meteors_y_pos = {}
local meteor_speed = {}

local w_height = 850
local w_width = 650

local dt

local total_meteor = 0 --score
  --text for scores
local total_x_pos = 20
local total_y_pos = w_height - 50

--background for stars
local star
local star_x_pos
local star_y_pos
local star_speed

local is_crash = false

local plane
local plane_x_pos
local plane_y_pos

local plane_x1_zone = 0
local plane_x2_zone = 0
local plane_y1_zone = 0
local plane_y2_zone = 0

local meteor_x1_zone = 0
local meteor_x2_zone = 0
local meteor_y1_zone = 0
local meteor_y2_zone = 0

local is_debug = false
local plane_width = 0
local plane_height = 0

local plane_crash

--load...
function love.load()
  --objects
  plane = love.graphics.newImage("starship.png")
  plane_crash = love.graphics.newImage("AtomicBomb.png")

  --init other objects
  init_meteors()
  init_background_stars()

  --locale variables
  r = 0

  plane_width = plane:getWidth()
  plane_height = plane:getHeight()

  width = plane:getWidth()
  height = plane:getHeight()
  speed = 300

  plane_x = (w_width/2) - (width / 2)
  plane_y = w_height - (height )

  love.graphics.setBackgroundColor(24, 56, 108)
  love.window.setMode(w_width, w_height)

  update_plane_zone()

end

--update...
function love.update(dt)
  update_stars(dt)

  if not is_crash then
	  if love.keyboard.isDown("right") then
		if plane_x <= (w_width) then
		  plane_x = plane_x + (speed * dt)
		  --r = r + 2
		end
	  end

	  if love.keyboard.isDown("left") then
		if plane_x >= 0 then
		  plane_x = plane_x - (speed * dt)
		  --r = r - 2
		end
	  end

	  update_meteors(dt)

	  update_plane_zone()
	  crash_detector()
  end
  debug_update(dt)
end

--lets draw...
function love.draw()
  --drawing all objects...
  draw_stars()
  draw_meteors()

  --draw plane
  love.graphics.draw(plane, plane_x, plane_y, math.rad(180), 1, 1, width / 2, height / 2)

  --print information
  draw_info_total_avoid()
  draw_info_press_to_exit()

  draw_plane_crash(is_crash)
  debug_draw()
end

--some key functions
function love.keyreleased(key)
   if key == 'escape' then
      game_quit()
   elseif key == 'q' then
      game_quit()
   elseif key == 'r' then
      restart_game()
   end
end

--for exit...
function game_quit()
  print("exit game....")
  love.event.quit()
end

--meteors functions
function init_meteors()
  for x=1, total_meteors do
  	meteors[x] = love.graphics.newImage("meteor.png")
    meteors_x_pos[x] = math.random(20, (w_width - 20))
    meteors_y_pos[x] = math.random(20, 50)
    meteor_speed[x] = math.random(100, 350)
  end
end

function update_pos_meteor(index, dt)  
  if meteors_y_pos[index] <= w_height then
    meteors_y_pos[index] = meteors_y_pos[index] + (meteor_speed[index] * dt)
  end

  if meteors_y_pos[index] > w_height then
    meteors_x_pos[index] = math.random(10, (w_width - 20))
    meteors_y_pos[index] = math.random(30, 50)
    total_meteor = total_meteor + 1
  end
end

function update_meteors(dt)
  for x=1, total_meteors do
    update_pos_meteor(x, dt)
  end
end

function draw_meteors()
  for x=1, total_meteors do
    love.graphics.draw(meteors[x], meteors_x_pos[x], meteors_y_pos[x], 0, 0.5, 0.5, meteors[x]:getWidth() / 2, meteors[x]:getHeight() / 2)
  end
end

function reset_meteors()
  for x=1, total_meteors do
    meteors_x_pos[x] = math.random(20, (w_width - 20))
    meteors_y_pos[x] = math.random(20, 50)
    meteor_speed[x] = math.random(100, 350)
  end
end

--text functions
function draw_info_press_to_exit()
  love.graphics.print("Press ESC or q to exit - r to restart", total_x_pos, w_height - 27, 0, 1.5, 1.5)
end

function draw_info_total_avoid()
  love.graphics.print("Scores: ", total_x_pos, total_y_pos, 0, 1.5, 1.5)
  love.graphics.print(total_meteor, total_x_pos + 74, total_y_pos, 0, 1.5, 1.5)
end

--background functions
function init_background_stars()
  	star = love.graphics.newImage("stars.png")
    star_x_pos = 0 --math.random(0, (w_width - 20))
    star_y_pos = 0 - star:getHeight()
    star_speed = 90
end

function update_stars(dt)
  if star_y_pos <= w_height then
    star_y_pos = star_y_pos + (star_speed * dt)
  end

  if star_y_pos > w_height then
    star_x_pos = math.random(0, (w_width - 20))
    star_y_pos = 0 - star:getHeight()
  end
end

function draw_stars()
  love.graphics.draw(star, star_x_pos, star_y_pos)
end

function crash_detector()
  for x=1, total_meteors do
    update_meteors_zone(x)
    if (plane_y1_zone <= meteor_y2_zone) and (plane_y2_zone >= meteor_y1_zone) then
      if (meteor_x1_zone <= plane_x2_zone) and (meteor_x2_zone >= plane_x1_zone) then
        is_crash = true
      end
    end
  end
end

--plane functions
function update_plane_zone()
  plane_x1_zone = plane_x - (plane:getWidth() / 3) --left border
  plane_x2_zone = plane_x + (plane:getWidth() / 3) --right border

  plane_y1_zone = plane_y - (plane:getHeight() / 4) --top
  plane_y2_zone = plane_y + (plane:getHeight() / 4) --bottom
end

function update_meteors_zone(index)
  meteor_x1_zone = meteors_x_pos[index] - (meteors[index]:getWidth() / 5) --left border
  meteor_x2_zone = meteors_x_pos[index] + (meteors[index]:getWidth() / 5) --right border

  meteor_y1_zone = meteors_y_pos[index] - (meteors[index]:getHeight() / 15) --top
  meteor_y2_zone = meteors_y_pos[index] + (meteors[index]:getHeight() / 5) --bottom
end

function draw_plane_crash(is_crash)
  if is_crash then
    --love.graphics.print("crash", w_width - 100, w_height - 27, 0, 1.5, 1.5)
    draw_plane_crash_image()
  else
    --love.graphics.print("not_crash", w_width - 100, w_height - 27, 0, 1.5, 1.5)
  end
end

function restart_game()
  is_crash = false
  reset_meteors()
  total_meteor = 0
end

function debug_update(dt)
  if is_debug then
    debut_plane_update(dt)
  end
end

function debug_draw()
  if is_debug then
    debug_plane_draw()
    debug_meteors_draw()

    if is_crash then
	  love.graphics.print("crash", w_width - 100, w_height - 27, 0, 1.5, 1.5)
    else
	  love.graphics.print("not_crash", w_width - 100, w_height - 27, 0, 1.5, 1.5)
    end
  end
end

function debut_plane_update(dt)
end

function debug_plane_draw()
  love.graphics.rectangle("fill", plane_x1_zone, plane_y1_zone, (plane_x2_zone - plane_x1_zone), (plane_y2_zone - plane_y1_zone))
  love.graphics.draw(plane, plane_x, plane_y, math.rad(180), 1, 1, plane_width / 2, plane_height / 2)
end

function debug_meteors_draw()
  for x=1, total_meteors do
    update_meteors_zone(x)
    love.graphics.rectangle("fill", meteor_x1_zone, meteor_y1_zone, (meteor_x2_zone - meteor_x1_zone), (meteor_y2_zone - meteor_y1_zone))
    love.graphics.draw(meteors[x], meteors_x_pos[x], meteors_y_pos[x], math.rad(0), 0.5, 0.5, meteors[x]:getWidth() / 2, meteors[x]:getHeight() / 2)
    --love.graphics.line(meteor_x1_zone,meteor_y1_zone, meteor_x1_zone,meteor_y2_zone+(meteors[x]:getHeight() / 2))
    --love.graphics.line(meteor_x2_zone,meteor_y1_zone, meteor_x2_zone,meteor_y2_zone+(meteors[x]:getHeight() / 2))
  end
end

function draw_plane_crash_image()
  love.graphics.draw(plane_crash, plane_x, plane_y, math.rad(0), 1, 1, plane_width / 2, plane_height / 2)
end
